(function() {
    const tocToggle = document.getElementById('tocToggle');
    const tocClose = document.getElementById('tocClose');
    const tocPanel = document.getElementById('tocPanel');
    const content = document.getElementById('content');
    const tocList = document.getElementById('tocList');
    const tocEmpty = document.getElementById('tocEmpty');
    
    let isOpen = false;
    
    // 切换目录显示状态
    function toggleToc() {
        isOpen = !isOpen;
        if (isOpen) {
            tocPanel.classList.add('open');
            content.classList.add('toc-open');
        } else {
            tocPanel.classList.remove('open');
            content.classList.remove('toc-open');
        }
    }
    
    // 生成目录
    function generateToc() {
        const headings = content.querySelectorAll('h1, h2, h3, h4, h5, h6');
        
        if (headings.length === 0) {
            tocEmpty.style.display = 'block';
            return;
        }
        
        tocEmpty.style.display = 'none';
        tocList.innerHTML = '';
        
        headings.forEach((heading, index) => {
            // 为标题添加ID（如果没有的话）
            if (!heading.id) {
                heading.id = `heading-${index}`;
            }
            
            const level = parseInt(heading.tagName.charAt(1));
            const text = heading.textContent || '';
            
            const li = document.createElement('li');
            li.className = 'toc-item';
            
            const link = document.createElement('a');
            link.className = `toc-link level-${level}`;
            link.textContent = text;
            link.href = `#${heading.id}`;
            link.addEventListener('click', (e) => {
                e.preventDefault();
                heading.scrollIntoView({ 
                    behavior: 'smooth',
                    block: 'start'
                });
                
                // 更新活跃状态
                document.querySelectorAll('.toc-link').forEach(l => l.classList.remove('active'));
                link.classList.add('active');
            });
            
            li.appendChild(link);
            tocList.appendChild(li);
        });
    }
    
    // 滚动时高亮当前标题
    function updateActiveHeading() {
        const headings = content.querySelectorAll('h1, h2, h3, h4, h5, h6');
        const tocLinks = document.querySelectorAll('.toc-link');
        
        let currentActive = null;
        const scrollTop = content.scrollTop;
        
        headings.forEach((heading, index) => {
            const rect = heading.getBoundingClientRect();
            const contentRect = content.getBoundingClientRect();
            
            if (rect.top - contentRect.top <= 100) {
                currentActive = index;
            }
        });
        
        tocLinks.forEach((link, index) => {
            link.classList.toggle('active', index === currentActive);
        });
    }
    
    // 事件监听
    tocToggle.addEventListener('click', toggleToc);
    tocClose.addEventListener('click', toggleToc);
    
    // 滚动监听
    content.addEventListener('scroll', updateActiveHeading);
    
    // 初始化
    // 使用 requestAnimationFrame 确保DOM渲染完成后再执行
    requestAnimationFrame(() => {
        generateToc();
        // 显示按钮
        tocToggle.style.animationPlayState = 'running';
    });
    
    // 键盘快捷键 (Ctrl/Cmd + Shift + O)
    document.addEventListener('keydown', (e) => {
        if ((e.ctrlKey || e.metaKey) && e.shiftKey && e.key === 'O') {
            e.preventDefault();
            toggleToc();
        }
    });
})(); 