// Webview 通用功能脚本
(function () {
	'use strict';

	const vscode = acquireVsCodeApi();

	// 处理所有链接点击事件
	document.addEventListener('click', function (event) {
		const target = event.target;

		// 检查是否点击了链接，排除锚点链接
		if (target.tagName.toLowerCase() === 'a' && target.href && !target.href.startsWith('vscode-webview')) {
			event.preventDefault();

			// 发送消息给扩展处理链接打开
			vscode.postMessage({
				type: 'openLink',
				href: target.href
			});
		}
	});

	// 导出 vscode API 供其他脚本使用
	window.vscodeApi = vscode;
})();
