"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepoWikiOverviewWebviewProvider = void 0;
const vscode = __importStar(require("vscode"));
const getNonce_1 = require("../utils/getNonce");
const l10n = __importStar(require("@vscode/l10n"));
class RepoWikiOverviewWebviewProvider {
    constructor(_extensionUri, qoderApi, statusManager, context) {
        this._extensionUri = _extensionUri;
        this.qoderApi = qoderApi;
        this.statusManager = statusManager;
        this.context = context;
        // 注册为状态监听器
        this.statusManager.addStatusListener(this);
        // 自动注册清理逻辑
        this.context.subscriptions.push({
            dispose: () => {
                this.statusManager.removeStatusListener(this);
            }
        });
    }
    /**
     * 检查 webview 是否可见
     */
    get visible() {
        return this._webviewView?.visible ?? false;
    }
    resolveWebviewView(webviewView, _context, _token) {
        this._webviewView = webviewView;
        webviewView.webview.options = {
            enableScripts: true,
            localResourceRoots: [this._extensionUri]
        };
        webviewView.webview.html = this._getHtmlForWebview(webviewView.webview);
        // 发送国际化字符串到 webview
        this._sendI18nStrings();
        // 监听 webview 可见性变化
        webviewView.onDidChangeVisibility(() => {
            this.statusManager.setComponentVisibility('webview', webviewView.visible);
        });
        // 初始化时设置可见性
        this.statusManager.setComponentVisibility('webview', webviewView.visible);
        // 监听来自 webview 的消息
        webviewView.webview.onDidReceiveMessage(async (message) => {
            switch (message.type) {
                case 'repoWiki.pause':
                    await this.repoWikiPause();
                    break;
                case 'repoWiki.resume':
                    await this.repoWikiResume();
                    break;
                case 'repoWiki.retry':
                    await this.repoWikiRetry();
                    break;
                case 'repoWiki.getStatus':
                    // 直接使用 StatusManager 获取状态
                    await this.statusManager.fetchStatusImmediately();
                    break;
            }
        }, undefined, []);
    }
    async repoWikiPause() {
        try {
            await this.qoderApi.repoWiki.pauseWikiGeneration();
        }
        catch (error) {
            vscode.window.showErrorMessage(l10n.t('Pause operation failed'));
        }
    }
    async repoWikiResume() {
        try {
            await this.qoderApi.repoWiki.startWikiGeneration();
        }
        catch (error) {
            vscode.window.showErrorMessage(l10n.t('Resume operation failed'));
        }
    }
    async repoWikiRetry() {
        try {
            await this.qoderApi.repoWiki.startWikiGeneration();
        }
        catch (error) {
            vscode.window.showErrorMessage(l10n.t('Retry operation failed'));
        }
    }
    /**
     * 实现 StatusListener 接口
     * 当状态更新时被调用
     */
    onStatusUpdate(status, statusDetails) {
        this.updateStatus(status, statusDetails);
    }
    // 公共方法：更新状态到webview
    updateStatus(status, statusDetails) {
        this._webviewView?.webview.postMessage({
            type: 'statusUpdate',
            status: status,
            statusDetails: statusDetails
        });
    }
    // 发送国际化字符串到 webview
    _sendI18nStrings() {
        const i18nStrings = {
            // 状态文本
            waiting: l10n.t('Pending...'),
            queuing: l10n.t('Pending...'),
            initializing: l10n.t('Initializing...'),
            generating_directory: l10n.t('Generating directory...'),
            generating_document: l10n.t('Generating document...'),
            paused: l10n.t('Paused'),
            completed: l10n.t('Completed'),
            partly_completed: l10n.t('Partly completed'),
            initialization_failed: l10n.t('Initialization failed'),
            directory_generation_failed: l10n.t('Directory generation failed'),
            document_generation_failed: l10n.t('Document generation failed'),
            not_source_control: l10n.t('Source Control projects only'),
            too_many_files: l10n.t('Repository size limit exceeded'),
            no_file_failed: l10n.t('Empty Folder'),
            // 状态描述
            waiting_to_start_analysis: l10n.t('The repository is waiting to be analyzed…'),
            queuing_for_processing: l10n.t('The repository is waiting to be analyzed…'),
            initializing_analysis_system: l10n.t('Initializing analysis'),
            generating_document_directory_structure: l10n.t('Generating document directory structure'),
            generating_document_content: l10n.t('Generating document content'),
            generation_process_paused: l10n.t('Click “Continue” to resume generation'),
            document_generation_completed: l10n.t('Document generation completed'),
            error_during_initialization: l10n.t('Error during initialization'),
            error_during_directory_generation: l10n.t('Directory generation failed. You can regenerate it.'),
            error_during_document_generation: l10n.t('Error during document generation'),
            project_not_in_version_control: l10n.t('Source Control projects only'),
            project_files_exceed_limit: l10n.t('Analysis is unavailable because the repository contains more than 6,000 files'),
            no_file_failed_description: l10n.t('The folder is empty, so the Wiki cannot be generated. Add at least one valid file in Explorer, then reopen the folder.'),
            // 按钮文本
            pause: l10n.t('Pause'),
            start: l10n.t('Continue'),
            retry: l10n.t('Retry'),
            // 进度信息
            progress_details: l10n.t('Progress: {0}/{1} ({2}%) - Processing: {3}, Failed: {4}'),
            completion_details: l10n.t('Completed: {0}/{1}, Failed: {2}'),
            unknown_status: l10n.t('Unknown status'),
            // 日志信息
            start_status_polling: l10n.t('Start status polling'),
            stop_status_polling: l10n.t('Stop status polling'),
            webview_visibility_changed: l10n.t('RepoWiki webview visibility changed: {0}')
        };
        this._webviewView?.webview.postMessage({
            type: 'i18nStrings',
            strings: i18nStrings
        });
    }
    _getHtmlForWebview(webview) {
        const nonce = (0, getNonce_1.getNonce)();
        // 获取外部JavaScript文件的URI
        const scriptUri = webview.asWebviewUri(vscode.Uri.joinPath(this._extensionUri, 'media', 'repo-wiki.js'));
        // 获取CSS文件的URI
        const styleUri = webview.asWebviewUri(vscode.Uri.joinPath(this._extensionUri, 'media', 'repo-wiki.css'));
        // 获取图标文件的URI
        const loadingIconUri = webview.asWebviewUri(vscode.Uri.joinPath(this._extensionUri, 'media', 'loading.svg'));
        const failedIconUri = webview.asWebviewUri(vscode.Uri.joinPath(this._extensionUri, 'media', 'failed.svg'));
        const warningIconUri = webview.asWebviewUri(vscode.Uri.joinPath(this._extensionUri, 'media', 'warning.svg'));
        const pauseIconUri = webview.asWebviewUri(vscode.Uri.joinPath(this._extensionUri, 'media', 'pause.svg'));
        return `<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
	<meta http-equiv="Content-Security-Policy" content="default-src 'none'; style-src ${webview.cspSource} 'unsafe-inline'; script-src 'nonce-${nonce}'; img-src ${webview.cspSource}; ">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>RepoWiki</title>
	<link rel="stylesheet" href="${styleUri}">
</head>
<body>
	<div class="card">
		<div class="card_info">
			<div class="card_progress">
				<div class="card_progress_icon"></div>
				<span class="card_progress_text">${l10n.t('Waiting...')}</span>
			</div>
			<div class="card_progress_description">${l10n.t('Waiting to start analysis')}</div>
		</div>
		<div class="card_operation">
			<button class="card_operation_button" id="pauseBtn" type="button">Pause</button>
		</div>
	</div>


	<script nonce="${nonce}">
		// 将图标URI传递给JavaScript
		window.iconUris = {
			loading: '${loadingIconUri}',
			failed: '${failedIconUri}',
			warning: '${warningIconUri}',
			pause: '${pauseIconUri}'
		};
	</script>
	<script nonce="${nonce}" src="${scriptUri}"></script>
</body>
</html>`;
    }
}
exports.RepoWikiOverviewWebviewProvider = RepoWikiOverviewWebviewProvider;
RepoWikiOverviewWebviewProvider.viewType = 'repoWiki.webview';
//# sourceMappingURL=RepoWikiWebviewProvider.js.map