"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.L10nUtils = exports.languageType = void 0;
const vscode = __importStar(require("vscode"));
const l10n = __importStar(require("@vscode/l10n"));
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
exports.languageType = {
    '简体中文': "zh-cn" /* Lang.zh */,
    'English': "en" /* Lang.en */,
};
class L10nUtils {
    static ensureInitialize(extensionContext) {
        if (L10nUtils.initializedL10n) {
            return;
        }
        // 获取当前VSCode的语言设置
        const currentVSCodeLang = vscode.env.language;
        console.log('VSCode language:', currentVSCodeLang);
        // 根据VSCode语言设置确定要使用的语言
        let targetLang;
        if (currentVSCodeLang.startsWith('zh')) {
            targetLang = "zh-cn" /* Lang.zh */;
        }
        else {
            targetLang = "en" /* Lang.en */;
        }
        L10nUtils.lang = targetLang;
        // 读取l10n文件
        const l10nRootPath = extensionContext.extensionPath;
        const l10nBundle = new Map();
        l10nBundle.set("zh-cn" /* Lang.zh */, '/l10n/bundle.l10n.zh-cn.json');
        l10nBundle.set("en" /* Lang.en */, '/l10n/bundle.l10n.json');
        const contents = {};
        l10nBundle.forEach((value, key) => {
            const absL10nFilePath = path.join(l10nRootPath, value);
            console.log(`Loading l10n file: ${absL10nFilePath}`);
            if (fs.existsSync(absL10nFilePath)) {
                try {
                    const fileContent = fs.readFileSync(absL10nFilePath, 'utf8');
                    contents[key] = JSON.parse(fileContent);
                    console.log(`Successfully loaded ${key} l10n file`);
                }
                catch (error) {
                    console.error(`Failed to load ${key} l10n file:`, error);
                }
            }
            else {
                console.warn(`L10n file not found: ${absL10nFilePath}`);
            }
        });
        // 配置l10n
        if (contents[targetLang]) {
            l10n.config({
                contents: contents[targetLang],
            });
            console.log(`L10n initialized with language: ${targetLang}`);
        }
        else {
            console.warn(`No l10n content found for language: ${targetLang}`);
        }
        L10nUtils.initializedL10n = true;
        L10nUtils.contents = contents;
    }
}
exports.L10nUtils = L10nUtils;
L10nUtils.initializedL10n = false;
L10nUtils.lang = "zh-cn" /* Lang.zh */;
L10nUtils.contents = {};
//# sourceMappingURL=l10nUtils.js.map