/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

//@ts-check

'use strict';

const withDefaults = require('../shared.webpack.config');

module.exports = withDefaults({
	context: __dirname,
	entry: {
		extension: './src/extension.ts',
		'diff-worker': './src/diff-history/diff-worker.ts',
	},
	externals: {
		'vscode': 'commonjs vscode',
		'axios': 'commonjs axios',
		'node-fetch': 'commonjs node-fetch',
	}
});
