"use strict";
/* Note: This file has been modified significantly from its original contents. New commands have been added, a fork of Continue (https://github.com/continuedev/continue)." */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerAllCommands = registerAllCommands;
const fs = __importStar(require("node:fs"));
const os = __importStar(require("node:os"));
const path = __importStar(require("node:path"));
const vscode = __importStar(require("vscode"));
const utils_1 = require("./util/dummyProxyUtils/utils");
const copySettings_1 = require("./copySettings");
const viewTypes_1 = require("./product/viewTypes");
const command_1 = require("./product/command");
let fullScreenPanel;
function getFullScreenTab() {
    const tabs = vscode.window.tabGroups.all.flatMap((tabGroup) => tabGroup.tabs);
    return tabs.find((tab) => tab.input?.viewType?.endsWith(viewTypes_1.AI_IDE_CHAT_VIEW_ID));
}
/**
 * Helper method to add the `isCommandEvent` to all telemetry captures
 */
function captureCommandTelemetry(commandName, properties = {}) {
    utils_1.Telemetry.capture(commandName, { isCommandEvent: true, ...properties });
}
// Copy everything over from extension.ts
const commandsMap = (extensionContext, sidebar) => {
    return {
        [command_1.Command.importUserSettingsFromVSCode]: async () => {
            return await (0, copySettings_1.importUserSettingsFromVSCode)(extensionContext);
        },
        [command_1.Command.importUserSettingsFromCursor]: async () => {
            return await (0, copySettings_1.importUserSettingsFromCursor)(extensionContext);
        },
        [command_1.Command.markNewOnboardingComplete]: async () => {
            await extensionContext.globalState.update(viewTypes_1.FIRST_LAUNCH_KEY, true);
        },
        [command_1.Command.restFirstLaunchInGUI]: async () => {
            sidebar.webviewProtocol?.request('restFirstLaunchInGUI', undefined, [
                viewTypes_1.AI_IDE_CHAT_VIEW_ID,
            ]);
        },
        [command_1.Command.showInteractiveContinueTutorial]: async () => {
            sidebar.webviewProtocol?.request('showInteractiveContinueTutorial', undefined, [viewTypes_1.AI_IDE_CHAT_VIEW_ID]);
        },
        [command_1.Command.viewLogs]: async () => {
            captureCommandTelemetry('viewLogs');
            // Open ~/.aicode/aicode.log
            const logFile = path.join(os.homedir(), viewTypes_1.IDE_DATA_FOLDER_NAME, viewTypes_1.IDE_LOG_FILENAME);
            // Make sure the file/directory exist
            if (!fs.existsSync(logFile)) {
                fs.mkdirSync(path.dirname(logFile), { recursive: true });
                fs.writeFileSync(logFile, '');
            }
            const uri = vscode.Uri.file(logFile);
            await vscode.window.showTextDocument(uri);
        },
        [command_1.Command.getUserAuth]: async () => {
            // TODO: This may need some work, for now we dont have vscode ExtensionContext access in the ideProtocol.ts so this will do
            const accessToken = await extensionContext.secrets.get(viewTypes_1.LOGIN_AUTH_TOKEN_KEY);
            const refreshToken = await extensionContext.secrets.get(viewTypes_1.AUTH_REFRESH_FLAG_KEY);
            const creds = {
                accessToken: accessToken ? accessToken.toString() : null,
                refreshToken: refreshToken ? refreshToken.toString() : null,
            };
            return creds;
        },
        [command_1.Command.updateUserAuth]: async (data) => {
            // Ensure that refreshToken and accessToken are both present
            if (!data || !(data.refreshToken && data.accessToken)) {
                vscode.window.showWarningMessage('Lingma IDE: Failed to parse user auth request!');
                return;
            }
            extensionContext.secrets.store(viewTypes_1.LOGIN_AUTH_TOKEN_KEY, data.accessToken);
            extensionContext.secrets.store(viewTypes_1.AUTH_REFRESH_FLAG_KEY, data.refreshToken);
        },
        [command_1.Command.manualLogin]: async () => {
            const accessToken = await vscode.window.showInputBox({
                prompt: 'Enter your Access Token',
                ignoreFocusOut: true,
                password: true, // Hides input for security
            });
            if (!accessToken) {
                vscode.window.showErrorMessage('Lingma IDE: Access Token is required!');
                return;
            }
            const refreshToken = await vscode.window.showInputBox({
                prompt: 'Enter your Refresh Token',
                ignoreFocusOut: true,
                password: true, // Hides input for security
            });
            if (!refreshToken) {
                vscode.window.showErrorMessage('Lingma IDE: Refresh Token is required!');
                return;
            }
            vscode.commands.executeCommand('Lingma IDE.updateUserAuth', {
                accessToken,
                refreshToken,
            });
        },
    };
};
function registerAllCommands(context, extensionContext, sidebar) {
    for (const [command, callback] of Object.entries(commandsMap(extensionContext, sidebar))) {
        context.subscriptions.push(vscode.commands.registerCommand(command, callback));
    }
}
//# sourceMappingURL=commands.js.map