"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeExtension = void 0;
const uuid_1 = require("uuid");
const vscode = __importStar(require("vscode"));
const commands_1 = require("../commands");
const ContinueGUIWebviewViewProvider_1 = require("../ContinueGUIWebviewViewProvider");
const VsCodeMessenger_1 = require("./VsCodeMessenger");
const viewTypes_1 = require("../product/viewTypes");
const messenger_1 = require("../util/dummyProxyUtils/messenger");
const command_1 = require("../product/command");
const ideProtocol_1 = require("../ideProtocol");
class VsCodeExtension {
    ide;
    extensionContext;
    sidebar;
    windowId;
    webviewProtocolPromise;
    constructor(context) {
        let resolveWebviewProtocol = undefined;
        this.webviewProtocolPromise = new Promise((resolve) => {
            resolveWebviewProtocol = resolve;
        });
        this.extensionContext = context;
        this.ide = new ideProtocol_1.VsCodeIde();
        this.windowId = (0, uuid_1.v4)();
        let resolveConfigHandler = undefined;
        const configHandlerPromise = new Promise((resolve) => {
            resolveConfigHandler = resolve;
        });
        this.sidebar = new ContinueGUIWebviewViewProvider_1.ContinueGUIWebviewViewProvider(configHandlerPromise, this.windowId, this.extensionContext);
        // Sidebar + Overlay
        context.subscriptions.push(vscode.window.registerWebviewViewProvider(viewTypes_1.AI_IDE_CHAT_VIEW_ID, this.sidebar, {
            webviewOptions: { retainContextWhenHidden: true },
        }));
        resolveWebviewProtocol(this.sidebar.webviewProtocol);
        const inProcessMessenger = new messenger_1.InProcessMessenger();
        new VsCodeMessenger_1.VsCodeMessenger(inProcessMessenger, this.sidebar.webviewProtocol, this.ide);
        // handleURI
        // This is the entry point when user signs in from web app
        context.subscriptions.push(vscode.window.registerUriHandler({
            handleUri(uri) {
                if (uri.authority === viewTypes_1.EXTENSION_AUTH_PREFIX) {
                    if (uri.path === '/ping') {
                        vscode.window.showInformationMessage('Lingma IDE received a custom URI!');
                    }
                    else if (uri.path === '/auth') {
                        const queryParams = new URLSearchParams(uri.query);
                        const data = {
                            accessToken: queryParams.get('accessToken'),
                            refreshToken: queryParams.get('refreshToken'),
                        };
                        vscode.commands.executeCommand(command_1.Command.updateUserAuth, data);
                    }
                }
            },
        }));
        // Commands
        (0, commands_1.registerAllCommands)(context, context, this.sidebar);
        // Create a file system watcher
        const watcher = vscode.workspace.createFileSystemWatcher('**/*', false, false, false);
        // Handle file creation
        watcher.onDidCreate(() => {
            this.refreshContextProviders();
        });
        // Handle file deletion
        watcher.onDidDelete(() => {
            this.refreshContextProviders();
        });
        context.subscriptions.push(watcher);
    }
    async refreshContextProviders() {
        this.sidebar.webviewProtocol.request('refreshSubmenuItems', undefined); // Refresh all context providers
    }
}
exports.VsCodeExtension = VsCodeExtension;
//# sourceMappingURL=VsCodeExtension.js.map