"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContinueGUIWebviewViewProvider = void 0;
const vscode = __importStar(require("vscode"));
const util_1 = require("./util/util");
const vscode_1 = require("./util/vscode");
const webviewProtocol_1 = require("./webviewProtocol");
const copySettings_1 = require("./copySettings");
const viewTypes_1 = require("./product/viewTypes");
const command_1 = require("./product/command");
const configuration_1 = require("./product/configuration");
class ContinueGUIWebviewViewProvider {
    configHandlerPromise;
    windowId;
    extensionContext;
    static viewType = viewTypes_1.AI_IDE_CHAT_VIEW_ID;
    webviewProtocol;
    _webview;
    _webviewView;
    outputChannel;
    enableDebugLogs;
    updateDebugLogsStatus() {
        const settings = vscode.workspace.getConfiguration(configuration_1.APPLICATION_NAME);
        this.enableDebugLogs = settings.get('enableDebugLogs', false);
        if (this.enableDebugLogs) {
            this.outputChannel.show(true);
        }
        else {
            this.outputChannel.hide();
        }
    }
    // Show or hide the output channel on enableDebugLogs
    setupDebugLogsListener() {
        vscode.workspace.onDidChangeConfiguration((event) => {
            if (event.affectsConfiguration(configuration_1.ENABLE_DEBUG_LOGS)) {
                const settings = vscode.workspace.getConfiguration(configuration_1.APPLICATION_NAME);
                const enableDebugLogs = settings.get('enableDebugLogs', false);
                if (enableDebugLogs) {
                    this.outputChannel.show(true);
                }
                else {
                    this.outputChannel.hide();
                }
            }
        });
    }
    async handleWebviewMessage(message) {
        if (message.messageType === 'log') {
            const settings = vscode.workspace.getConfiguration(configuration_1.APPLICATION_NAME);
            const enableDebugLogs = settings.get('enableDebugLogs', false);
            if (message.level === 'debug' && !enableDebugLogs) {
                return; // Skip debug logs if enableDebugLogs is false
            }
            const timestamp = new Date().toISOString().split('.')[0];
            const logMessage = `[${timestamp}] [${message.level.toUpperCase()}] ${message.text}`;
            this.outputChannel.appendLine(logMessage);
        }
        else if (message.messageType === 'onboardingComplete') {
            await vscode.commands.executeCommand('workbench.action.toggleFullScreen');
            await vscode.commands.executeCommand(command_1.Command.markNewOnboardingComplete);
            await vscode.commands.executeCommand(command_1.Command.hideOverlay);
        }
    }
    resolveWebviewView(webviewView, _context, _token) {
        this._webview = webviewView.webview;
        this._webview.onDidReceiveMessage((message) => {
            return this.handleWebviewMessage(message);
        });
        webviewView.webview.html = this.getSidebarContent(this.extensionContext, webviewView);
    }
    get isVisible() {
        return this._webviewView?.visible;
    }
    get webview() {
        return this._webview;
    }
    resetWebviewProtocolWebview() {
        if (this._webview) {
            this.webviewProtocol.resetWebviewToDefault();
        }
        else {
            console.warn('no webview found during reset');
        }
    }
    sendMainUserInput(input) {
        this.webview?.postMessage({
            type: 'userInput',
            input,
        });
    }
    constructor(configHandlerPromise, windowId, extensionContext) {
        this.configHandlerPromise = configHandlerPromise;
        this.windowId = windowId;
        this.extensionContext = extensionContext;
        this.outputChannel = vscode.window.createOutputChannel(`${configuration_1.OUTPUT_CHANNEL} Landing`);
        this.enableDebugLogs = false;
        this.updateDebugLogsStatus();
        this.setupDebugLogsListener();
        this.webviewProtocol = new webviewProtocol_1.VsCodeWebviewProtocol((async () => {
            const configHandler = await this.configHandlerPromise;
            return configHandler.reloadConfig();
        }).bind(this));
    }
    getSidebarContent(context, panel, page = undefined, edits = undefined, isFullScreen = false, initialRoute = '/') {
        const panelViewType = panel?.viewType; // eg. AI_CHAT_VIEW_ID
        const isOverlay = panel?.title === viewTypes_1.AI_IDE_OVERLAY_VIEW_ID; // defined in ai-ide OverlayPart.ts
        const extensionUri = (0, vscode_1.getExtensionUri)();
        let scriptUri;
        let styleMainUri;
        const vscMediaUrl = panel.webview
            .asWebviewUri(vscode.Uri.joinPath(extensionUri, 'gui', 'dist'))
            .toString();
        const inDevelopmentMode = context?.extensionMode === vscode.ExtensionMode.Development;
        if (!inDevelopmentMode) {
            scriptUri = panel.webview
                .asWebviewUri(vscode.Uri.joinPath(extensionUri, 'gui/dist/assets/index.js'))
                .toString();
            styleMainUri = panel.webview
                .asWebviewUri(vscode.Uri.joinPath(extensionUri, 'gui/dist/assets/index.css'))
                .toString();
        }
        else {
            scriptUri = 'http://localhost:5173/src/main.tsx';
            styleMainUri = 'http://localhost:5173/src/index.css';
        }
        panel.webview.options = {
            enableScripts: true,
            localResourceRoots: [
                vscode.Uri.joinPath(extensionUri, 'gui'),
                vscode.Uri.joinPath(extensionUri, 'assets'),
            ],
            enableCommandUris: true,
            portMapping: [
                {
                    webviewPort: 65433,
                    extensionHostPort: 65433,
                },
            ],
        };
        const nonce = (0, vscode_1.getNonce)();
        this.webviewProtocol.addWebview(panel?.title === viewTypes_1.AI_IDE_OVERLAY_VIEW_ID ? panel.title : panel.viewType, panel.webview);
        return `<!DOCTYPE html>
    <html lang="en">
      <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <script>
          const vscode = acquireVsCodeApi();
        </script>
        <link href="${styleMainUri}" rel="stylesheet">

        <title>Lingma IDE</title>
      </head>
      <body>
        <div id="root"></div>

        ${`<script>
        function log(level, ...args) {
          const text = args.map(arg =>
            typeof arg === 'object' ? JSON.stringify(arg) : String(arg)
          ).join(' ');
          vscode.postMessage({ messageType: 'log', level, text, messageId: "log" });
        }

        window.console.log = (...args) => log('log', ...args);
        window.console.info = (...args) => log('info', ...args);
        window.console.warn = (...args) => log('warn', ...args);
        window.console.error = (...args) => log('error', ...args);
        window.console.debug = (...args) => log('debug', ...args);

        console.debug('Logging initialized');
        </script>`}
        ${inDevelopmentMode
            ? `<script type="module">
          import RefreshRuntime from "http://localhost:5173/@react-refresh"
          RefreshRuntime.injectIntoGlobalHook(window)
          window.$RefreshReg$ = () => {}
          window.$RefreshSig$ = () => (type) => type
          window.__vite_plugin_react_preamble_installed__ = true
          </script>`
            : ''}

        <script type="module" nonce="${nonce}" src="${scriptUri}"></script>

        <script>localStorage.setItem("ide", '"vscode"')</script>
        <script>localStorage.setItem("extensionVersion", '"${(0, util_1.getExtensionVersion)()}"')</script>
        <script>window.windowId = "${this.windowId}"</script>
        <script>window.vscMachineId = "${(0, vscode_1.getUniqueId)()}"</script>
        <script>window.vscMediaUrl = "${vscMediaUrl}"</script>
        <script>window.ide = "vscode"</script>
        <script>window.colorThemeName = "dark-plus"</script>
        <script>window.workspacePaths = ${JSON.stringify(vscode.workspace.workspaceFolders?.map((folder) => folder.uri.fsPath) || [])}</script>
        <script>window.isFirstLaunch = ${(0, copySettings_1.isFirstLaunch)(this.extensionContext)}</script>
        <script>window.isFullScreen = ${isFullScreen}</script>
        <script>window.viewType = "${panelViewType}"</script>
        <script>window.isLandingOverlay = ${isOverlay}</script>
        <script>window.initialRoute = "${initialRoute}"</script>
        <script>window.vscodeLanguage = "${vscode.env.language}"</script>

        ${edits
            ? `<script>window.edits = ${JSON.stringify(edits)}</script>`
            : ''}
        ${page ? `<script>window.location.pathname = "${page}"</script>` : ''}
      </body>
      ${isOverlay
            ? `
          <style>
            body {
              margin: 0;
              padding: 0;
              background-color: transparent;
              width: 100vw;
              height: 100vh;
              display: flex;
              justify-content: center;
              align-items: center;
              position: fixed;
              top: 0;
              left: 0;
            }

            #root {
              width: 100%;
              height: 100%;
            }
          </style>
          <script>
            document.body.addEventListener('click', function(e) {
                if (e.target === document.body) {
                    vscode.postMessage({ messageType: 'closeOverlay', messageId: "closeOverlay" });
                    vscode.commands.executeCommand("workbench.action.focusActiveEditorGroup");
                }
            });
          </script>
      `
            : ''}
    </html>`;
    }
}
exports.ContinueGUIWebviewViewProvider = ContinueGUIWebviewViewProvider;
//# sourceMappingURL=ContinueGUIWebviewViewProvider.js.map