"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.detectLang = detectLang;
exports.setI18nLang = setI18nLang;
exports.getCurrentLang = getCurrentLang;
exports.isZh = isZh;
exports.t = t;
exports.refreshLang = refreshLang;
const vscode = __importStar(require("vscode"));
// 简单多语言工具
let currentLang = detectLang();
function detectLang() {
    // 优先从 vscode.env.language 读取
    if (vscode.env.language) {
        return vscode.env.language.startsWith('zh') ? 'zh' : 'en';
    }
    // 其他情况默认英文
    return 'en';
}
function setI18nLang(lang) {
    currentLang = lang.startsWith('zh') ? 'zh' : 'en';
}
function getCurrentLang() {
    return currentLang;
}
function isZh() {
    return currentLang === 'zh';
}
// t: (zh, en) => string
function t(zh, en) {
    return isZh() ? zh : en;
}
// 刷新语言设置
function refreshLang() {
    currentLang = detectLang();
}
//# sourceMappingURL=i18n.js.map